# pomocná funkcia
def vypis(g):
    for u in range(len(g)):
        print(u, ':', g[u])


# Funkcia vráti číslo osoby s najväčším počtom priateľov.
# V prípade, že žiadny priatelia neexistujú, vráti hodnotu -1.
# Spolu s číslom osoby vrátime aj hodnotu nájdeného maxima.
def najviac_priatelov(g):
    osoba = max = -1
    for u in range(len(g)):
        pocet = 0
        for v in g[u]:
            if u in g[v]:  # overenie existencie hrany
                pocet += 1
        if pocet > max:
            max = pocet
            osoba = u
    return osoba, max


# hlavný program
# spracovanie vstupného súboru
with open('vstup.txt') as f:
    # prečítame počet vrcholov
    n = int(f.readline())
    # pripravíme zoznam so zoznamami susedov jednotlivých vrcholov
    g = [[] for i in range(n)]
    for riadok in f:
        hrana = riadok.split()
        u = int(hrana[0])
        v = int(hrana[1])
        # ak uv je hrana, do zoznamu susedov vrcholu pridáme vrchol v
        g[u].append(v)

# výpis zoznamu zoznamov susedných vrcholov
vypis(g)
# výpočet a výpis výsledkov
osoba, pocet = najviac_priatelov(g)
print(f'Osoba {osoba} ma {pocet} priatelov.')
